/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Vec3i;
import net.minecraft.util.FastColor;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;

public interface VertexConsumer {
    public VertexConsumer addVertex(float var1, float var2, float var3);

    public VertexConsumer setColor(int var1, int var2, int var3, int var4);

    public VertexConsumer setUv(float var1, float var2);

    public VertexConsumer setUv1(int var1, int var2);

    public VertexConsumer setUv2(int var1, int var2);

    public VertexConsumer setNormal(float var1, float var2, float var3);

    default public void addVertex(float p_351049_, float p_350528_, float p_351018_, int p_350427_, float p_350508_, float p_350864_, int p_350846_, int p_350731_, float p_350784_, float p_351051_, float p_350759_) {
        this.addVertex(p_351049_, p_350528_, p_351018_);
        this.setColor(p_350427_);
        this.setUv(p_350508_, p_350864_);
        this.setOverlay(p_350846_);
        this.setLight(p_350731_);
        this.setNormal(p_350784_, p_351051_, p_350759_);
    }

    default public VertexConsumer setColor(float p_350350_, float p_350356_, float p_350623_, float p_350312_) {
        return this.setColor((int)(p_350350_ * 255.0f), (int)(p_350356_ * 255.0f), (int)(p_350623_ * 255.0f), (int)(p_350312_ * 255.0f));
    }

    default public VertexConsumer setColor(int p_350809_) {
        return this.setColor(FastColor.ARGB32.red(p_350809_), FastColor.ARGB32.green(p_350809_), FastColor.ARGB32.blue(p_350809_), FastColor.ARGB32.alpha(p_350809_));
    }

    default public VertexConsumer setWhiteAlpha(int p_350979_) {
        return this.setColor(FastColor.ARGB32.color(p_350979_, -1));
    }

    default public VertexConsumer setLight(int p_350855_) {
        return this.setUv2(p_350855_ & 0xFFFF, p_350855_ >> 16 & 0xFFFF);
    }

    default public VertexConsumer setOverlay(int p_350697_) {
        return this.setUv1(p_350697_ & 0xFFFF, p_350697_ >> 16 & 0xFFFF);
    }

    default public void putBulkData(PoseStack.Pose p_85996_, BakedQuad p_85997_, float p_85999_, float p_86000_, float p_86001_, float p_331520_, int p_86003_, int p_331548_) {
        this.putBulkData(p_85996_, p_85997_, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, p_85999_, p_86000_, p_86001_, p_331520_, new int[]{p_86003_, p_86003_, p_86003_, p_86003_}, p_331548_, false);
    }

    default public void putBulkData(PoseStack.Pose p_85988_, BakedQuad p_85989_, float[] p_331397_, float p_85990_, float p_85991_, float p_85992_, float p_331416_, int[] p_331378_, int p_85993_, boolean p_331268_) {
        int[] $$10 = p_85989_.getVertices();
        Vec3i $$11 = p_85989_.getDirection().getNormal();
        Matrix4f $$12 = p_85988_.pose();
        Vector3f $$13 = p_85988_.transformNormal($$11.getX(), $$11.getY(), $$11.getZ(), new Vector3f());
        int $$14 = 8;
        int $$15 = $$10.length / 8;
        int $$16 = (int)(p_331416_ * 255.0f);
        try (MemoryStack $$17 = MemoryStack.stackPush();){
            ByteBuffer $$18 = $$17.malloc(DefaultVertexFormat.BLOCK.getVertexSize());
            IntBuffer $$19 = $$18.asIntBuffer();
            for (int $$20 = 0; $$20 < $$15; ++$$20) {
                float $$32;
                float $$31;
                float $$30;
                $$19.clear();
                $$19.put($$10, $$20 * 8, 8);
                float $$21 = $$18.getFloat(0);
                float $$22 = $$18.getFloat(4);
                float $$23 = $$18.getFloat(8);
                if (p_331268_) {
                    float $$24 = $$18.get(12) & 0xFF;
                    float $$25 = $$18.get(13) & 0xFF;
                    float $$26 = $$18.get(14) & 0xFF;
                    float $$27 = $$24 * p_331397_[$$20] * p_85990_;
                    float $$28 = $$25 * p_331397_[$$20] * p_85991_;
                    float $$29 = $$26 * p_331397_[$$20] * p_85992_;
                } else {
                    $$30 = p_331397_[$$20] * p_85990_ * 255.0f;
                    $$31 = p_331397_[$$20] * p_85991_ * 255.0f;
                    $$32 = p_331397_[$$20] * p_85992_ * 255.0f;
                }
                int $$33 = FastColor.ARGB32.color($$16, (int)$$30, (int)$$31, (int)$$32);
                int $$34 = p_331378_[$$20];
                float $$35 = $$18.getFloat(16);
                float $$36 = $$18.getFloat(20);
                Vector3f $$37 = $$12.transformPosition($$21, $$22, $$23, new Vector3f());
                this.addVertex($$37.x(), $$37.y(), $$37.z(), $$33, $$35, $$36, p_85993_, $$34, $$13.x(), $$13.y(), $$13.z());
            }
        }
    }

    default public VertexConsumer addVertex(Vector3f p_350685_) {
        return this.addVertex(p_350685_.x(), p_350685_.y(), p_350685_.z());
    }

    default public VertexConsumer addVertex(PoseStack.Pose p_352288_, Vector3f p_352298_) {
        return this.addVertex(p_352288_, p_352298_.x(), p_352298_.y(), p_352298_.z());
    }

    default public VertexConsumer addVertex(PoseStack.Pose p_350506_, float p_350934_, float p_350873_, float p_350981_) {
        return this.addVertex(p_350506_.pose(), p_350934_, p_350873_, p_350981_);
    }

    default public VertexConsumer addVertex(Matrix4f p_350929_, float p_350884_, float p_350885_, float p_350942_) {
        Vector3f $$4 = p_350929_.transformPosition(p_350884_, p_350885_, p_350942_, new Vector3f());
        return this.addVertex($$4.x(), $$4.y(), $$4.z());
    }

    default public VertexConsumer setNormal(PoseStack.Pose p_350592_, float p_350534_, float p_350411_, float p_350441_) {
        Vector3f $$4 = p_350592_.transformNormal(p_350534_, p_350411_, p_350441_, new Vector3f());
        return this.setNormal($$4.x(), $$4.y(), $$4.z());
    }
}

